jQuery(document).ready(function ($) {
    $(".tmt-preloader").delay(2000).fadeOut("fast");
	$(".tmt-navbar-wrapper").parents('.elementor-row,.elementor-container').addClass('position-menu');
    $(".drop-down-btn").parents('.elementor-top-column').addClass('position-drop-down');
	
    // Accordion
    $(".tmt-accordion-title").on("click", function() {
        if ($(this).hasClass("tmt-open")) {
            $(this).removeClass("tmt-open");
            $(this).siblings(".tmt-accordion-content").slideUp(200);
        } else {
            if ($(this).hasClass("multiple")) {}
            else {
                $(".tmt-accordion-title").removeClass("tmt-open");
                $(".tmt-accordion-content").slideUp(200);
            }
            $(this).addClass("tmt-open");
            $(this).siblings(".tmt-accordion-content").slideDown(200);
        }
    });

    //item icon tab
    $(".services_item-wrap:first-child .services_item-icon,.services_item-wrap:first-child .services_item-content").addClass('current');
    $('.services_item-wrap > .services_item-icon').hover(function(e){
        e.stopPropagation();
        var tab_id = $(this).attr('data-tab');
        $('.services_item-wrap > .services_item-icon').removeClass('current');
        $('.services_item-wrap > .services_item-content').removeClass('current');
        $(this).addClass('current');
        $("#"+tab_id).addClass('current');
    });
    // Tabs    
    $('.tab-nav-item').on("click", function() {
        var id = $(this).attr('rel');
        $(this).parents('.tmt-tabs').find('.tmt-open').removeClass('tmt-open');
        $(this).addClass('tmt-open');
        $('#'+id).addClass('tmt-open');
    });

    // STAART Back to Top Settings
    var btn = $('#top');
    $(window).scroll(function() {
        if ($(window).scrollTop() > 500) {
            btn.fadeIn();
        } else {
            btn.fadeOut();
        }
    });
    btn.on('click', function(e) {
        e.preventDefault();
        $('html, body').animate({scrollTop:0}, '300');
    });
    // END Back to Top Settings

    
    // Whatsapp
    $( ".whatsapp-pupup" ).click(function(e) {
        e.stopPropagation();
        $( ".whatsapp-chat" ).toggleClass( "open-chat");
        $(this).children("i").toggleClass( "fab fa-whatsapp fas fa-times");
    });
    
    // Modal
    $( ".tmt-modal-botton a" ).click(function(e) {
        e.stopPropagation();
        $(this).parents(".tmt-modal").toggleClass( "tmt-open");
        $( ".tmt-modal-close,.tmt-modal-bg" ).click(function(e) {e.stopPropagation();$(this).parents(".tmt-modal").removeClass( "tmt-open");});
    });
    $( ".auto .tmt-modal-close,.auto .tmt-modal-bg" ).click(function(e) {
        e.stopPropagation();
        $(this).parents(".tmt-modal-bg").css({"opacity": "0", "visibility": "hidden","animation": "none"});
        $(this).css({"opacity": "0", "visibility": "hidden","animation": "none"});
    });
    $('.tmt-modal-box').click(function(e){e.stopPropagation();});

    // Icon header
    $(window).click(function(){$(".drop-down-content").slideUp(300);});
    $('.drop-down-content,.drop-down-btn').click(function(e){e.stopPropagation();});
    $(".drop-down-btn").on("click", function(e) {
        e.preventDefault();
        if ($(this).hasClass("tmt-open")) {
            $(this).removeClass("tmt-open");
            $(this).next(".drop-down-content").slideUp(300);
        } else {
            $(".drop-down-btn").removeClass("tmt-open");
            $(".drop-down-content").slideUp(300);
            $(this).addClass("tmt-open");
            $(this).next(".drop-down-content").slideDown(300);
        }
    });
});

( function( $ ) {
    var WidgetElementorTabHandler = function( $scope, $ ) {
        $scope.find('.tab-nav-item').on("click", function() {
            var id = $(this).attr('rel');
            $(this).parents('.tmt-tabs').find('.tmt-open').removeClass('tmt-open');
            $(this).addClass('tmt-open');
            $('#'+id).addClass('tmt-open');
        });
    };
    var WidgetElementorSliderHandler = function( $scope, $ ) {
        $('.tmt-slider-yes').each(function () {
            var setting = $(this).attr("data-swiper"),
            id = $(this).attr("id"),
            items = JSON.parse(setting);
            const swiperParams = {
                slidesPerView: items.columns,
                navigation: {
                    nextEl: '#'+ id +' .swiper-button-next',
                    prevEl: '#'+ id +' .swiper-button-prev',
                },
                loop: items.infinite,
                centeredSlides: items.centerMode,
                pagination: {
                    el: '#'+ id +' .swiper-pagination',
                    clickable: true,
                },
                breakpoints: {
                    10: {slidesPerView: items.columns_mobile,},
                    480: {slidesPerView: items.columns_mobile_h,},
                    768: {slidesPerView: items.columns_tablet,},
                    1024: {slidesPerView: items.columns,},
                }
            };

            if(items.autoplay) {
                swiperParams.autoplay = {
                    delay: items.speed,
                    disableOnInteraction: false
                };
                if(items.pause_on_hover) {
                    $('#'+id).on('mouseover', function() {swiper.autoplay.stop();});    
                    $('#'+id).on('mouseout', function() {swiper.autoplay.start();});
                }
            }

            if(items.effect && items.effect !== 'none') {
                switch(items.effect) {
                    case 'fade':
                        swiperParams.effect = "fade";
                        break;
                    case 'cube':
                        swiperParams.effect = "cube";
                        swiperParams.grabCursor = true;
                        swiperParams.cubeEffect = {
                            shadow: true,
                            slideShadows: true,
                            shadowOffset: 20,
                            shadowScale: 0.94,
                        };
                        break;
                    case 'coverflow':
                        swiperParams.effect = "coverflow";
                        swiperParams.grabCursor = true;
                        swiperParams.coverflowEffect = {
                            rotate: 50,
                            stretch: 0,
                            depth: 100,
                            modifier: 1,
                            slideShadows: true,
                        };
                        break;
                    case 'flip':
                        swiperParams.effect = "flip";
                        swiperParams.grabCursor = true;
                        break;
                    case 'cards':
                        swiperParams.effect = "cards";
                        swiperParams.grabCursor = true;
                        break;
                    case 'creative':
                        swiperParams.effect = "creative";
                        switch (items['creative-type']) {
                            case "1":
                              swiperParams.creativeEffect = {
                                prev: {
                                  shadow: true,
                                  translate: [0, 0, -400],
                                },
                                next: {
                                  translate: ["100%", 0, 0],
                                },
                              };
                              break;
                            case "2":
                              swiperParams.creativeEffect = {
                                prev: {
                                  shadow: true,
                                  translate: ["-120%", 0, -500],
                                },
                                next: {
                                  shadow: true,
                                  translate: ["120%", 0, -500],
                                },
                              };
                              break;
                              case "3":
                              swiperParams.creativeEffect = {
                                prev: {
                                  shadow: true,
                                  translate: ["-20%", 0, -1],
                                },
                                next: {
                                  translate: ["100%", 0, 0],
                                },
                              };
                              break;
                              case "4":
                              swiperParams.creativeEffect = {
                                prev: {
                                    shadow: true,
                                    translate: [0, 0, -800],
                                    rotate: [180, 0, 0],
                                },
                                next: {
                                    shadow: true,
                                    translate: [0, 0, -800],
                                    rotate: [-180, 0, 0],
                                },
                              };
                              break;
                            case "5":
                              swiperParams.creativeEffect = {
                                prev: {
                                    shadow: true,
                                    translate: ["-125%", 0, -800],
                                    rotate: [0, 0, -90],
                                },
                                next: {
                                    shadow: true,
                                    translate: ["125%", 0, -800],
                                    rotate: [0, 0, 90],
                                },
                              };
                              break;
                            case "6":
                              swiperParams.creativeEffect = {
                                prev: {
                                    shadow: true,
                                    origin: "left center",
                                    translate: ["-5%", 0, -200],
                                    rotate: [0, 100, 0],
                                },
                                next: {
                                    origin: "right center",
                                    translate: ["5%", 0, -200],
                                    rotate: [0, -100, 0],
                                },
                              };
                              break;
                        }
                          break;
                }
            }

            const swiper = new Swiper('#'+id, swiperParams);
        });
        
    };
    var WidgetElementorMenuHandler = function( $scope, $ ) {
        $scope.find('.menu').click(function(){$('.responsive-fix .tmt-navbar-wrapper').removeClass('open-menu');});
        $scope.find(window).click(function(){$('.responsive-under .tmt-navbar-wrapper').removeClass('open-menu');});
        $scope.find('.responsive-under .tmt-navbar-wrapper').click(function(e){e.stopPropagation();});
    	$scope.find('.main-menu').click(function(e){e.stopPropagation();});
        $scope.find(".bars").click(function(e){
            e.preventDefault();
            if($(this).parents('.tmt-navbar-wrapper').hasClass('open-menu')) {
                $('.tmt-navbar-wrapper').removeClass('open-menu');
            } else {
                $('.tmt-navbar-wrapper').removeClass('open-menu');
                $(this).parents('.tmt-navbar-wrapper').addClass('open-menu');
            }
        });
        $scope.find(".menu-item-has-children").click(function(e) {e.stopPropagation();$(this).toggleClass('open-sub-menu');});
        $scope.find(".menu-item-has-children > ul").click(function(e) {e.stopPropagation();$(this).addClass('open-sub-menu');});
        $scope.find(".open-sub-menu-yes .menu-item-has-children").addClass('open-sub-menu');
        $scope.find("li.mega-menu").parents("li.menu-item-has-children").addClass("main-mega-menu");
    };
    $( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/themento_slides.default', WidgetElementorSliderHandler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/themento_post_carousel.default', WidgetElementorSliderHandler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/themento-post-grid.default', WidgetElementorSliderHandler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/themento-product-classic.default', WidgetElementorSliderHandler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/tmt-testimonial.default', WidgetElementorSliderHandler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/tmt-tabs.default', WidgetElementorTabHandler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/tmt-navbar.default', WidgetElementorMenuHandler );
    } );
} )( jQuery );